const getURL = (() => {
  try {
    return browser.runtime.getURL;
  } catch (e) {
    console.log(e);
    return chrome.extension.getURL;
  }
})();

function load() {
  document.body.style.display = "hidden";

  (async () => {
    // Fetch bundled Sentralise app
    const req = await window.fetch(getURL("build/index.html"));
    const app = await req.text();

    // Replace entire webpage
    const htmlRoot = document.getElementsByTagName("html")[0];
    htmlRoot.innerHTML = app;

    // Run scripts
    runScripts(htmlRoot);
  })();
}

async function runScripts(element) {
  var scripts;

  // Get the scripts
  scripts = Array.prototype.slice
    .call(element.getElementsByTagName("script"))
    .sort((a, b) => (a.src ? 1 : -1));

  for (let i = 0; i < scripts.length; i++) {
    await new Promise((resolve, reject) => {
      var script = scripts[i];
      script.parentNode.removeChild(script);

      // Create a replacement for it
      var newscript = document.createElement("script");

      // External?
      if (script.src) {
        console.log(`loading script from ${script.src}`);
        // Yes, we'll have to wait until it's loaded before continuing
        newscript.onerror = () => {
          if (this === newscript) {
            resolve();
          }
        };
        newscript.onload = () => {
          if (this === newscript) {
            resolve();
          }
        };
        newscript.onreadystatechange = () => {
          if (this === newscript && this.readyState === "complete") {
            resolve();
          }
        };

        // Create url
        const path = `build/_nuxt/${script.src.split("/_nuxt/")[1]}`;
        newscript.src = getURL(path);
        newscript.type = script.type;
      } else {
        // No, we can do it right away
        newscript.text = script.text;
        resolve();
      }

      // Start the script
      element.appendChild(newscript);

      if (!script.src) {
        resolve();
      }
    });
  }
}


const validPaths = ["/auth", "/auth/portal", "/s-a7kAox/portal", "/pdfviewer"];

const stripped = window.location.pathname.replace(/\/+$/, "");

console.log(stripped);

validPaths.forEach((e) => {
  console.log(e, e == stripped);
  if (e == stripped) {
    load();
  }
});
