const getURL = (() => {
  try {
    return browser.runtime.getURL;
  } catch (e) {
    return chrome.extension.getURL;
  }
})();

const webRequest = (() => {
  try {
    return browser.webRequest;
  } catch (e) {
    return chrome.webRequest;
  }
})();

function interceptAssetRequest(requestDetails) {
  const path = `build/_nuxt/${requestDetails.url.split("/_nuxt/")[1]}`;
  console.log(path);
  return {
    redirectUrl: getURL(path),
  };
}

function interceptFaviconRequest(requestDetails) {
  return {
    redirectUrl: getURL("build/favicon.ico"),
  };
}

function killRequest(requestDetails) {
  return {
    cancel: true,
  };
}

webRequest.onBeforeRequest.addListener(
  interceptAssetRequest,
  {
    urls: ["*://stives-h.sentral.com.au/_nuxt/*"],
  },
  ["blocking"]
);

webRequest.onBeforeRequest.addListener(
  interceptFaviconRequest,
  {
    urls: ["*://stives-h.sentral.com.au/favicon.ico"],
  },
  ["blocking"]
);

webRequest.onBeforeRequest.addListener(
  killRequest,
  {
    urls: [
      "*://stives-h.sentral.com.au/_common/build/*",
      "*://stives-h.sentral.com.au/ajax/*",
      "*://stives-h.sentral.com.au/js/*",
    ],
  },
  ["blocking"]
);
